/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.inventory.ContainerUtility;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import java.util.Arrays;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1690;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_4838;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_7248;
import net.minecraft.class_7265;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerShip
extends Ship
implements class_7248,
class_7265 {
    public static final class_2940<Integer> CONTAINER_SIZE = class_2945.method_12791(ContainerShip.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Byte> ROWS = class_2945.method_12791(ContainerShip.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> PAGES = class_2945.method_12791(ContainerShip.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> PAGE_INDEX = class_2945.method_12791(ContainerShip.class, (class_2941)class_2943.field_13319);
    private final int originalContainerSize;
    class_2371<class_1799> itemStacks;
    @Nullable
    private class_2960 lootTable;
    private long lootTableSeed;
    public final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ContainerShip.this.getData(ROWS).byteValue();
                case 1 -> ContainerShip.this.getData(PAGES).byteValue();
                case 2 -> ContainerShip.this.getData(PAGE_INDEX).byteValue();
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    ContainerShip.this.setData(ROWS, (byte)value);
                    break;
                }
                case 1: {
                    ContainerShip.this.setData(PAGES, (byte)value);
                    break;
                }
                case 2: {
                    ContainerShip.this.setData(PAGE_INDEX, (byte)value);
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public ContainerShip(class_1299<? extends class_1690> entityType, class_1937 level, int containerSize) {
        super(entityType, level);
        this.updatePaging(containerSize);
        this.originalContainerSize = containerSize;
        this.itemStacks = class_2371.method_10213((int)containerSize, (Object)class_1799.field_8037);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(CONTAINER_SIZE, (Object)this.originalContainerSize);
        this.method_5841().method_12784(ROWS, (Object)6);
        this.method_5841().method_12784(PAGES, (Object)1);
        this.method_5841().method_12784(PAGE_INDEX, (Object)0);
    }

    @Override
    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.method_42285(tag);
        this.readContainerSizeSaveData(tag);
    }

    @Override
    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        this.method_42288(tag);
        this.addContainerSizeSaveData(tag);
    }

    public void method_42279(@NotNull class_1282 damageSource) {
        super.method_42279(damageSource);
        this.method_42283(damageSource, this.field_6002, (class_1297)this);
    }

    public void method_5650(@NotNull class_1297.class_5529 removalReason) {
        if (!this.field_6002.field_9236 && removalReason.method_31486()) {
            class_1264.method_5452((class_1937)this.field_6002, (class_1297)this, (class_1263)this);
        }
        super.method_5650(removalReason);
    }

    @Override
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        return this.method_5818((class_1297)player) && !player.method_21823() ? super.method_5688(player, interactionHand) : this.method_42284((arg_0, arg_1) -> ((ContainerShip)this).method_32875(arg_0, arg_1), player);
    }

    public void method_6722(@NotNull class_1657 player) {
        if (player.method_37908().method_8608() && this.method_5439() != this.itemStacks.size()) {
            this.itemStacks = ContainerShip.resizeItemStacks(this, this.method_5439());
        }
        ContainerUtility.openShipMenu(player, this);
        if (!player.method_37908().method_8608()) {
            this.method_32875(class_5712.field_28176, (class_1297)player);
            class_4838.method_24733((class_1657)player, (boolean)true);
        }
    }

    @Nullable
    public class_2960 method_42276() {
        return this.lootTable;
    }

    public void method_42275(@Nullable class_2960 resourceLocation) {
        this.lootTable = resourceLocation;
    }

    public long method_42277() {
        return this.lootTableSeed;
    }

    public void method_42274(long l) {
        this.lootTableSeed = l;
    }

    public class_2371<class_1799> method_42278() {
        return this.itemStacks;
    }

    public void method_42273() {
        this.itemStacks.clear();
    }

    public int method_5439() {
        return this.getData(CONTAINER_SIZE);
    }

    public class_1799 method_5438(int i) {
        return this.method_42290(i);
    }

    public class_1799 method_5434(int i, int j) {
        return this.method_42286(i, j);
    }

    public class_1799 method_5441(int i) {
        return this.method_42289(i);
    }

    public void method_5447(int i, @NotNull class_1799 itemStack) {
        this.method_42287(i, itemStack);
    }

    public class_5630 method_32318(int n) {
        return this.method_42292(n);
    }

    public void method_5431() {
    }

    public boolean method_5443(@NotNull class_1657 player) {
        return this.method_42294(player);
    }

    public void method_5448() {
        this.method_42293();
    }

    @Nullable
    public class_1703 createMenu(int syncId, @NotNull class_1661 inventory, @NotNull class_1657 player) {
        if (this.lootTable == null || !player.method_7325()) {
            this.method_42291(inventory.field_7546);
            this.method_6722(player);
        }
        return null;
    }

    public void method_42285(@NotNull class_2487 compoundTag) {
        this.method_42273();
        if (compoundTag.method_10573("LootTable", 8)) {
            this.method_42275(new class_2960(compoundTag.method_10558("LootTable")));
            this.method_42274(compoundTag.method_10537("LootTableSeed"));
        } else {
            ContainerUtility.loadAllItems(compoundTag, this.method_42278());
        }
    }

    public void method_42288(@NotNull class_2487 compoundTag) {
        if (this.method_42276() != null) {
            compoundTag.method_10582("LootTable", this.method_42276().toString());
            if (this.method_42277() != 0L) {
                compoundTag.method_10544("LootTableSeed", this.method_42277());
            }
        } else {
            ContainerUtility.saveAllItems(compoundTag, this.method_42278());
        }
    }

    public void readContainerSizeSaveData(class_2487 tag) {
        int containerSize;
        if (!tag.method_10573("ContainerSize", 3)) {
            tag.method_10569("ContainerSize", this.originalContainerSize);
        }
        if ((containerSize = tag.method_10550("ContainerSize")) == 0) {
            containerSize = this.originalContainerSize;
        }
        this.updatePaging(containerSize);
        this.itemStacks = ContainerShip.resizeItemStacks(this, containerSize);
        this.setData(CONTAINER_SIZE, containerSize);
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_18456().stream().filter(player -> {
                ShipContainerMenu shipContainerMenu;
                class_1703 patt9348$temp = player.field_7512;
                return patt9348$temp instanceof ShipContainerMenu && (shipContainerMenu = (ShipContainerMenu)patt9348$temp).getContainer().equals((Object)this);
            }).map(player -> (class_3222)player).forEach(class_3222::method_7346);
        }
    }

    public void addContainerSizeSaveData(class_2487 tag) {
        tag.method_10569("ContainerSize", this.getData(CONTAINER_SIZE).intValue());
    }

    private void updatePaging(int containerSize) {
        int pages;
        int rowsPerPage;
        block4: {
            if (containerSize % 9 != 0) {
                throw new IllegalArgumentException("ShipContainerMenu can not be created with size " + containerSize + ". Make sure to use a container size that is divisible by 9.");
            }
            int allRows = containerSize / 9;
            rowsPerPage = 6;
            pages = 1;
            while (true) {
                if (pages * rowsPerPage >= allRows) {
                    if (pages * rowsPerPage != allRows) {
                        --rowsPerPage;
                        pages = 1;
                        continue;
                    }
                    break block4;
                }
                if (++pages > 127) break;
            }
            throw new IllegalArgumentException("ShipContainerMenu can not be created with size " + containerSize + ". Make sure to use a container size that requires less or equal to 128 pages. Current amount of required pages: " + pages);
        }
        this.setData(ROWS, (byte)rowsPerPage);
        this.setData(PAGES, (byte)pages);
        this.setData(PAGE_INDEX, (byte)0);
    }

    private static class_2371<class_1799> resizeItemStacks(class_7265 containerEntity, int containerSize) {
        Object[] newItemStacks;
        class_1799[] oldItemStacks = (class_1799[])containerEntity.method_42278().toArray(class_1799[]::new);
        if (containerSize < oldItemStacks.length) {
            newItemStacks = Arrays.copyOfRange(oldItemStacks, 0, containerSize);
            oldItemStacks = (class_1799[])Arrays.stream(Arrays.copyOfRange(oldItemStacks, containerSize, oldItemStacks.length)).filter(stack -> !stack.method_7960()).toArray(class_1799[]::new);
            int j = 0;
            for (int i = 0; i < newItemStacks.length; ++i) {
                if (!newItemStacks[i].method_7960()) continue;
                if (j == oldItemStacks.length) break;
                newItemStacks[i] = oldItemStacks[j];
                ++j;
            }
            if (j < oldItemStacks.length) {
                class_1264.method_5452((class_1937)containerEntity.method_37908(), (class_1297)((class_1297)containerEntity), (class_1263)new class_1277(Arrays.copyOfRange(oldItemStacks, j, oldItemStacks.length)));
            }
        } else {
            newItemStacks = new class_1799[containerSize];
            for (int i = 0; i < containerSize; ++i) {
                newItemStacks[i] = i < oldItemStacks.length ? oldItemStacks[i] : class_1799.field_8037;
            }
        }
        return class_2371.method_10212((Object)class_1799.field_8037, (Object[])newItemStacks);
    }
}

